/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Entity.Projectiles;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public abstract class BaseFallenAmmo
extends Projectile
implements ItemSupplier {
    protected static final EntityDataAccessor<BlockPos> targetPosition = SynchedEntityData.m_135353_(BaseFallenAmmo.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    protected static final EntityDataAccessor<Integer> waitTick = SynchedEntityData.m_135353_(BaseFallenAmmo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> hurtDamage = SynchedEntityData.m_135353_(BaseFallenAmmo.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> killThreshold = SynchedEntityData.m_135353_(BaseFallenAmmo.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected boolean isArrived;
    protected int arrivedTime;
    protected boolean hasBeenSetSpeed;

    protected BaseFallenAmmo(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected BaseFallenAmmo(EntityType<? extends BaseFallenAmmo> pEntityType, LivingEntity owner, Level level, BlockPos targetPosition) {
        super(pEntityType, level);
        this.m_5602_((Entity)owner);
        this.setTargetPosition(targetPosition);
        RandomSource source = this.m_9236_().f_46441_;
        this.m_6034_(targetPosition.m_123341_() + source.m_188503_(30), targetPosition.m_123342_() + 50, targetPosition.m_123343_() + source.m_188503_(30));
        this.m_20242_(true);
        this.m_20256_(this.getVec3TargetPosition().m_82546_(this.m_20182_()).m_82490_((double)0.02f));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(targetPosition, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(waitTick, (Object)0);
        this.f_19804_.m_135372_(hurtDamage, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(killThreshold, (Object)Float.valueOf(0.21f));
    }

    public void setHurtDamage(float damage) {
        this.f_19804_.m_135381_(hurtDamage, (Object)Float.valueOf(damage));
    }

    public float getHurtDamage() {
        return ((Float)this.f_19804_.m_135370_(hurtDamage)).floatValue();
    }

    public void setWaitTime(int tick) {
        this.f_19804_.m_135381_(waitTick, (Object)tick);
    }

    public int getWaitTime() {
        return (Integer)this.f_19804_.m_135370_(waitTick);
    }

    public Vec3 getVec3TargetPosition() {
        return new Vec3((double)this.getTargetPosition().m_123341_(), (double)this.getTargetPosition().m_123342_(), (double)this.getTargetPosition().m_123343_());
    }

    public BlockPos getTargetPosition() {
        return (BlockPos)this.f_19804_.m_135370_(targetPosition);
    }

    public void setTargetPosition(BlockPos position) {
        this.f_19804_.m_135381_(targetPosition, (Object)new BlockPos((Vec3i)position));
    }

    public float getKillThreshold() {
        return ((Float)this.f_19804_.m_135370_(killThreshold)).floatValue();
    }

    public void setKillThreshold(float killThresholdValue) {
        this.f_19804_.m_135381_(killThreshold, (Object)Float.valueOf(killThresholdValue));
    }

    protected void onArrived(ServerPlayer player) {
        this.m_20256_(Vec3.f_82478_);
        this.isArrived = true;
    }

    protected void directHurtLiving(@Nullable DamageSource source, float amount, double range) {
        if (source != null && range > 0.0) {
            Vec3 vec3 = this.getVec3TargetPosition();
            int x = (int)vec3.m_7096_();
            int y = (int)vec3.m_7098_();
            int z = (int)vec3.m_7094_();
            List livingEntities = this.m_9236_().m_6443_(Mob.class, new AABB(new BlockPos(x, y, z)).m_82400_(range), lv -> {
                TamableAnimal animal;
                boolean base = lv != this.m_37282_() && lv.m_6084_();
                boolean isPet = lv instanceof TamableAnimal && (animal = (TamableAnimal)lv).m_21824_();
                return base && !isPet;
            });
            for (Mob lv2 : livingEntities) {
                lv2.m_6469_(source, amount);
            }
        }
    }

    protected abstract void shockWaveHurt(Mob var1, Player var2);

    private void commonTick() {
        this.f_19794_ = true;
        if (this.isArrived) {
            ++this.arrivedTime;
        }
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        boolean flag = false;
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)hitresult).m_82425_();
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
                flag = true;
            } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockentity = this.f_19853_.m_7702_(blockpos);
                if (blockentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                    TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
                }
                flag = true;
            }
        }
        if (hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d2 = this.m_20185_() + vec3.f_82479_;
        double d0 = this.m_20186_() + vec3.f_82480_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d2 - vec3.f_82479_ * 0.25, d0 - vec3.f_82480_ * 0.25, d1 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
        }
        if (!this.m_20068_()) {
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
        }
        this.m_6034_(d2, d0, d1);
    }

    @NotNull
    protected abstract ParticleOptions getTailParticleType();

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 200) {
            this.m_146870_();
        }
        if (this.getWaitTime() > 0) {
            this.setWaitTime(this.getWaitTime() - 1);
            return;
        }
        this.commonTick();
        if (this.getWaitTime() == 0 || !this.hasBeenSetSpeed) {
            this.hasBeenSetSpeed = true;
        }
        Vec3 vec3 = this.m_20184_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        Entity entity = this.m_37282_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (int i = 0; i < 4; ++i) {
                double x = vec3.f_82479_;
                double y = vec3.f_82480_;
                double z = vec3.f_82481_;
                player.m_9236_().m_8767_(this.getTailParticleType(), this.m_20185_() + x * (double)i / 4.0, this.m_20186_() + y * (double)i / 4.0, this.m_20189_() + z * (double)i / 4.0, 10, 0.0, 0.0, 0.0, 0.25);
            }
            if (this.m_20182_().m_82554_(this.getVec3TargetPosition()) < 1.0 && !this.isArrived) {
                this.onArrived(player);
            }
            if (this.isArrived && this.arrivedTime < 80) {
                Vec3 Vec3Pos = this.getVec3TargetPosition();
                BlockPos pos = new BlockPos((int)Vec3Pos.m_7096_(), (int)Vec3Pos.m_7098_(), (int)Vec3Pos.m_7094_());
                AABB aabb = new AABB(pos).m_82400_(100.0);
                List mobList = this.f_19853_.m_6443_(Mob.class, aabb, LivingEntity::m_6084_);
                for (Mob mob : mobList) {
                    double distance = mob.m_20182_().m_82546_(this.getVec3TargetPosition()).m_82553_();
                    if (distance < (double)(this.arrivedTime - 3) || distance > (double)(this.arrivedTime + 3)) continue;
                    this.shockWaveHurt(mob, (Player)player);
                }
            }
        }
    }
}

